.H 1 "Source Files Window"
The Source Files window lists the source files compiled
with the -g option that were used to construct the program.
From the line menus the files can be opened.
The window is opened by selecting "Source" in the "views"
menu in the Process window's menu bar and is only created if there
is more than one source file.
.P
The window's keyboard language allows you to specify a list of directories
to search when source files are opened.
The search path may be initialized with the PI_SRCPATH environment variable.
The menu bar allows different file path name components to be used
when files are located.
.H 2 "Source Files Layout"
The title bar identifies the process id number or name of the core file.
Each line lists the name of a source file.
Different options in the "src" menu allow either the full path name,
the file name given to the compiler on the command line, or the last
component in file name (the basename) to be displayed.
.P
If a directory search path has been set,
the first line in the window will displays the path:
.DS I N
Source Path: search_path
.DE
.P
The search path is a colon separated list of directories and
is in same format as the PATH environment variable used by
the Bourne or Korn shell.
If a file name displayed in the window is a relative path name
(it doesn't start with "/")
pi searches for the file in the directories listed in the search path
when the Source Text window for that file is opened.
Pi searches for files that start with "./" or "../"
(path names relative to the current or parent of the current directory)
in the current directory before trying the search path.
.P
For example, if pi keeps its source code in the directory
/usr/jtools/src/pi and uses the pads interface library
in the directory /usr/jtools/src/pads/host, typing:
.DS I N
/usr/jtools/src/pi:/usr/jtools/src/pads/host
.DE
.P
to the window displays the following on the first line:
.DS I N
Source Path: /usr/jtools/src/pi:/usr/jtools/src/pads/host
.DE
.P
and source files in either directory will be found.
.P
In most cases, the use of a search path is unnecessary, since turning
on the full path name option in the "src" menu locates files
in different directories.
However, this may fail for several reasons.
.AL 1
.LI
The creation of temporary files during compilation may
cause the full path information to be incorrect.
For instance, C++ translators based on cfront generate temporary C files.
.LI
The files may have been moved. 
.LI
Some compilers do not store the full path names of the
files in the symbol table.
.LE
.P
If the use of full path names fails, the
search path may be used to locate source files in
different directories without changing the working directory of the debugger.
A separate search path is maintained for each process.
.P
If the shell environment variable PI_SRCPATH is set,
pi uses its value as the initial setting for the source file search path.
In the example above you may use the following Bourne shell commands
to have the search path set automatically each time pi is invoked:
.DS I N
PI_SRCPATH=/usr/jtools/src/pi:/usr/jtools/src/pads/host
export PI_SRCPATH
.DE
.H 2 "Source Files Menu Bar"
The "src" menu controls which components of the file
path names are used to locate source files.
If the displayed file name is a relative path name (it doen't start with '/'),
pi searches for the file in the search path directories when it is opened.
The options are:
.VL 12 1
.LI "default"
Display the file names given to the compiler on the command line when
the files were compiled.
This is the default option.
.LI "basename"
Display the last components of the file names.
.LI "full path"
Display the full path names of the files.
If the compiler does not store this information in the symbol tabe,
this is equivalent to choosing "default".
.LE
.P
For example, if the file test1.c is compiled from the directory /usr/jtools
with the command line "cc -g -c test/test1.c",
the file name is displayed as shown below for the different options:
.DS I N
Option		File Name Displayed
---------	------------------------
default		test/test1.c
basename	test1.c
full path	/usr/jtools/test/test1.c
.DE
.P
If the directory search path is used, it should be set to "/usr/jtools"
when the "default" option is selected, and "/usr/jtools/test" when the
"basename" option is selected.
.H 2 "Source Files Keyboard"
Syntax
.DS I N
search_path
.DE
.P
The keyboard language allows you to enter a list of directories to search
when a source file is opened.
The format of the search path is the same as the PATH environment
variable in the Bourne shell.
It consists of a list of directory names separated by ":" characters.
The directories are searched in the order they are listed and the null
string specifies the current directory. 
For example, setting the search path to:
.DS I N
:/usr/jtools/src/pi:/usr/jtools/src/pads/host
.DE
.P
will search for a source file in sequence the current directory
(the null string before the first ":"),
/usr/jtools/src/pi and /usr/jtools/src/pads/host.
Unlike the PATH in the Bourne shell, the current directory is searched
even if it is not in the search path.
There is an implicit ":" on the end of the path.
.P
The current search path is displayed on the first line
of the window.
Reentering a new search path overwrites the previous entry.
.H 2 "Source Files Line Menus"
Each line listing a source file name generates the following menu.
.VL 20 1
.LI "open source file"
Open the Source Text window for the file.
.LE
